/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.item;

import com.nyfaria.numismaticoverhaul.cap.CurrencyHolderAttacher;
import com.nyfaria.numismaticoverhaul.currency.CurrencyConverter;
import com.nyfaria.numismaticoverhaul.currency.CurrencyHelper;
import com.nyfaria.numismaticoverhaul.currency.CurrencyResolver;
import com.nyfaria.numismaticoverhaul.init.ItemInit;
import com.nyfaria.numismaticoverhaul.item.CoinItem;
import com.nyfaria.numismaticoverhaul.item.CurrencyItem;
import com.nyfaria.numismaticoverhaul.item.CurrencyTooltipData;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.MerchantResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class MoneyBagItem
extends Item
implements CurrencyItem {
    public MoneyBagItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public ItemStack m_7968_() {
        ItemStack defaultStack = super.m_7968_();
        defaultStack.m_41784_().m_128356_("Value", 0L);
        return defaultStack;
    }

    public static ItemStack create(long value) {
        ItemStack stack = new ItemStack((ItemLike)ItemInit.MONEY_BAG.get());
        stack.m_41784_().m_128356_("Value", value);
        return stack;
    }

    public static ItemStack createCombined(long[] values) {
        ItemStack stack = new ItemStack((ItemLike)ItemInit.MONEY_BAG.get());
        stack.m_41784_().m_128388_("Values", values);
        stack.m_41784_().m_128379_("Combined", true);
        return stack;
    }

    @Override
    public long getValue(ItemStack stack) {
        if (!stack.m_150930_((Item)ItemInit.MONEY_BAG.get())) {
            return 0L;
        }
        if (!stack.m_41784_().m_128441_("Combined")) {
            return stack.m_41783_().m_128454_("value");
        }
        return CurrencyResolver.combineValues(CurrencyHelper.getFromNbt(stack.m_41784_(), "Values"));
    }

    @Override
    public long[] getCombinedValue(ItemStack stack) {
        if (!stack.m_41784_().m_128441_("Combined")) {
            return CurrencyResolver.splitValues(stack.m_41783_().m_128454_("value"));
        }
        return CurrencyHelper.getFromNbt(stack.m_41784_(), "Values");
    }

    public void setValue(ItemStack stack, long value) {
        stack.m_41784_().m_128356_("Value", value);
    }

    public void setCombinedValue(ItemStack stack, long[] values) {
        stack.m_41784_().m_128388_("Values", values);
    }

    public boolean m_142305_(ItemStack clickedStack, ItemStack otherStack, Slot slot, ClickAction clickType, Player player, SlotAccess cursorStackReference) {
        if (slot instanceof MerchantResultSlot) {
            return false;
        }
        if (clickType == ClickAction.SECONDARY && clickedStack.m_41720_() == this && otherStack.m_41619_()) {
            boolean canBeCompacted;
            List<ItemStack> stackRepresentation = CurrencyConverter.getAsValidStacks(this.getCombinedValue(clickedStack));
            if (stackRepresentation.isEmpty()) {
                return false;
            }
            ItemStack coinStack = stackRepresentation.get(0);
            cursorStackReference.m_142104_(coinStack);
            long[] values = this.getCombinedValue(clickedStack);
            int n = ((CoinItem)coinStack.m_41720_()).currency.ordinal();
            values[n] = values[n] - (long)coinStack.m_41613_();
            long newValue = CurrencyResolver.combineValues(values);
            boolean bl = canBeCompacted = values[0] < 100L && values[1] < 100L && values[2] < 100L;
            if (newValue == 0L) {
                slot.m_5852_(ItemStack.f_41583_);
            } else if (canBeCompacted && CurrencyConverter.getAsValidStacks(newValue).size() == 1) {
                slot.m_5852_(CurrencyConverter.getAsValidStacks(newValue).get(0));
            } else {
                this.setCombinedValue(clickedStack, values);
            }
        } else if (clickType == ClickAction.PRIMARY) {
            Item coinStack = otherStack.m_41720_();
            if (!(coinStack instanceof CurrencyItem)) {
                return false;
            }
            CurrencyItem currencyItem = (CurrencyItem)coinStack;
            long[] clickedValues = this.getCombinedValue(clickedStack);
            long[] otherValues = currencyItem.getCombinedValue(otherStack);
            for (int i = 0; i < clickedValues.length; ++i) {
                int n = i;
                clickedValues[n] = clickedValues[n] + otherValues[i];
            }
            slot.m_5852_(MoneyBagItem.createCombined(clickedValues));
            cursorStackReference.m_142104_(ItemStack.f_41583_);
        }
        return true;
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        long[] lArray;
        long[] lArray2 = this.getCombinedValue(stack);
        if (CurrencyItem.hasOriginalValue(stack)) {
            lArray = CurrencyResolver.splitValues(CurrencyItem.getOriginalValue(stack));
        } else {
            long[] lArray3 = new long[1];
            lArray = lArray3;
            lArray3[0] = -1L;
        }
        return Optional.of(new CurrencyTooltipData(lArray2, lArray));
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (stack.m_41784_().m_128471_("Combined")) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        player.m_150109_().m_36057_(stack);
        for (ItemStack toOffer : CurrencyConverter.getAsValidStacks(this.getValue(stack))) {
            player.m_150109_().m_150079_(toOffer);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        CurrencyHolderAttacher.getExampleHolderUnwrap((Entity)user).modify(this.getValue(user.m_21120_(hand)));
        user.m_21008_(hand, ItemStack.f_41583_);
        return InteractionResultHolder.m_19090_((Object)ItemStack.f_41583_);
    }

    @Override
    public boolean wasAdjusted(ItemStack other) {
        return true;
    }

    public Component m_41466_() {
        return super.m_41466_().m_6881_().m_6270_(((CoinItem)ItemInit.SILVER_COIN.get()).NAME_STYLE);
    }
}

